(function ($) {

  const input = document.querySelector("#phone_contact_phone");
  const fnameinput = document.querySelector("#name_contact_first_name");
  const lnameinput = document.querySelector("#name_contact_last_name");
  const emailinput = document.querySelector("#email_contact_email");
  const checkerinput = document.querySelector("#checkboxAgree");
  
  const iti = window.intlTelInput(input, {
    // allowDropdown: false,
    // autoPlaceholder: "off",
    // containerClass: "test",
    // countryOrder: ["jp", "kr"],
    // countrySearch: false,
    // customPlaceholder: function(selectedCountryPlaceholder, selectedCountryData) {
    //   return "e.g. " + selectedCountryPlaceholder;
    // },
    // dropdownContainer: document.querySelector('#custom-container'),
    // excludeCountries: ["us"],
    // fixDropdownWidth: false,
    // formatAsYouType: false,
    // formatOnDisplay: false,
    geoIpLookup: function(callback) {
       fetch("https://ipapi.co/json")
        .then(function(res) { return res.json(); })
         .then(function(data) { callback(data.country_code); })
        .catch(function() { callback(); });
     },
    // hiddenInput: () => ({ phone: "phone_full", country: "country_code" }),
    // i18n: { 'de': 'Deutschland' },
    initialCountry: "auto",
    // loadUtils: () => import("/build/js/utils.js"), // leading slash (and http-server) required for this to work in chrome
    // nationalMode: false,
    // onlyCountries: ['us', 'gb', 'ch', 'ca', 'do'],
    // placeholderNumberType: "MOBILE",
    // showFlags: false,
    separateDialCode: true,
    // strictMode: true,
    // useFullscreenPopup: true,
    // validationNumberTypes: null,
  });
  window.iti = iti; // useful for testing
  $("input:hidden[name='area_code']").val(iti.getSelectedCountryData().dialCode);
  const button = document.querySelector("#submit-contact-home");
  const errorMsg = document.querySelector("#error-msg");
  const validMsg = document.querySelector("#valid-msg");
  const errorMap = ["Invalid number", "Invalid country code", "Too short", "Too long", "Invalid number"];
  const namePattern = /^(?=(?:[^ ]* ){0,2}[^ ]*$)[a-zA-Z\u00C0-\u024F\-'. ]+$/;
  const spamKeywords = /(promo|http|www|\.com|offer|win)/i;
  const reset = () => {
    $("input:hidden[name='area_code']").val(iti.getSelectedCountryData().dialCode);
    input.classList.remove("error");
    errorMsg.innerHTML = "";
    //validMsg.innerHTML = "";
    errorMsg.classList.add("hide");
    //validMsg.classList.add("hide");
  };
  
  const reset2 = () => {
    const fname = document.getElementById("name_contact_first_name").value;
    const fnameErr = document.getElementById("name_contact_first_name-error");
    if (fname.length < 2) { 
      fnameErr.textContent = "Your first name is too short (at least 2 characters)";
      fnameErr.classList.add("showre");
      isValid = false;
    }
    else if (!namePattern.test(fname)) {
        fnameErr.textContent = "Please enter valid first name";
        fnameErr.classList.add("showre");
        isValid = false;
      }
    else if (spamKeywords.test(fname)) {
        fnameErr.textContent = "Invalid first name entry.";
        fnameErr.classList.add("showre");
        isValid = false;
      }
    else if (fname.length > 35) {
        fnameErr.textContent = "Your first name is too long";
        fnameErr.classList.add("showre");
        isValid = false;
      }
    else{
      fnameErr.textContent = "";
      fnameErr.classList.remove("showre");
    }
  }
  const reset3 = () => {
    const lname = document.getElementById("name_contact_last_name").value;
    const lnameErr = document.getElementById("name_contact_last_name-error");
    if (lname.length < 2) { 
      lnameErr.textContent = "Your last name is too short (at least 2 characters)";
      lnameErr.classList.add("showre");
      isValid = false;
    }
    else if (!namePattern.test(lname)) {
        lnameErr.textContent = "Please enter valid last name";
        lnameErr.classList.add("showre");
        isValid = false;
      }
    else if (spamKeywords.test(lname)) {
        lnameErr.textContent = "Invalid last name entry.";
        lnameErr.classList.add("showre");
        isValid = false;
      }
    else if (lname.length > 35) {
        lnameErr.textContent = "Your last name is too long";
        lnameErr.classList.add("showre");
        isValid = false;
      }
    else{
      lnameErr.textContent = "";
      lnameErr.classList.remove("showre");
    }
  }
  const reset4 = () => {
    const email = document.getElementById("email_contact_email").value;
    const emailErr = document.getElementById("email_contact_email-error");
    if (!/\S+@\S+\.[A-Za-z]{2,}/.test(email)) {
      emailErr.textContent = "Please enter a valid email address.";
      emailErr.classList.add("showre");
      isValid = false;
    }else{
      emailErr.textContent = "";
      emailErr.classList.remove("showre");
    }
  }
  
  const reset5 = () => {
    var checkBox = document.getElementById("checkboxAgree");
    var checkerErr = document.getElementById("checkboxAgree-error");
    if (checkBox.checked === false){
        checkerErr.textContent = "Please agree terms and condition";
        checkerErr.classList.add("showre");
              isValid = false;
        }else{
      checkerErr.textContent = "";
      checkerErr.classList.remove("showre");
        }
  }
  
  const showError = (msg) => {
    input.classList.add("error");
    errorMsg.innerHTML = msg;
    errorMsg.classList.remove("hide");
  };
  
  
  function validateForm() {
    const fname = document.getElementById("name_contact_first_name").value;
    const lname = document.getElementById("name_contact_last_name").value;
    const email = document.getElementById("email_contact_email").value;
    
    const fnameErr = document.getElementById("name_contact_first_name-error");
    const lnameErr = document.getElementById("name_contact_last_name-error");
    const emailErr = document.getElementById("email_contact_email-error");
    const checkerErr = document.getElementById("checkboxAgree-error");
    const formmessage = document.getElementById("message-home");
    const namePattern = /^(?=(?:[^ ]* ){0,2}[^ ]*$)[a-zA-Z\u00C0-\u024F\-'. ]+$/;
    const spamKeywords = /(free|promo|http|www|\.com|offer|win)/i;
  
    fnameErr.textContent = "";
    lnameErr.textContent = "";
    emailErr.textContent = "";
      var checkBox = document.getElementById("checkboxAgree");
    let isValid = true;
    if (checkBox.checked === false){
        checkerErr.textContent = "Please agree terms and condition";
        checkerErr.classList.add("showre");
              isValid = false;
        }else{
      checkerErr.textContent = "";
      checkerErr.classList.remove("showre");
        }
    if (fname.length < 2) { 
      fnameErr.textContent = "Your first name is too short (at least 2 characters)";
      fnameErr.classList.add("showre");
      isValid = false;
    }
    if (!namePattern.test(fname)) {
        fnameErr.textContent = "Please enter valid first name";
        fnameErr.classList.add("showre");
        isValid = false;
      }
    if (spamKeywords.test(fname)) {
        fnameErr.textContent = "Invalid first name entry.";
        fnameErr.classList.add("showre");
        isValid = false;
      }
    if (fname.length > 35) {
        fnameErr.textContent = "Your first name is too long";
        fnameErr.classList.add("showre");
        isValid = false;
      }
    if (lname.length < 2) { 
      lnameErr.textContent = "Your last name is too short (at least 2 characters)";
      lnameErr.classList.add("showre");
      isValid = false;
    }
    if (!namePattern.test(lname)) {
        lnameErr.textContent = "Please enter valid last name";
        lnameErr.classList.add("showre");
        isValid = false;
      }
    if (spamKeywords.test(lname)) {
        lnameErr.textContent = "Invalid last name entry.";
        lnameErr.classList.add("showre");
        isValid = false;
      }
    if (lname.length > 35) {
        lnameErr.textContent = "Your last name is too long";
        lnameErr.classList.add("showre");
        isValid = false;
      }
    if (!/\S+@\S+\.[A-Za-z]{2,}/.test(email)) {
      emailErr.textContent = "Please enter a valid email address.";
      emailErr.classList.add("showre");
      isValid = false;
    }
    if (!input.value.trim()) {
      showError("Required");
    } else if (iti.isValidNumber()) {
      //validMsg.innerHTML = "Valid number: " + iti.getNumber();
      //validMsg.classList.remove("hide");
    } else {
      const errorCode = iti.getValidationError();
      const msg = errorMap[errorCode] || "Invalid number";
      showError(msg);
      isValid = false;
    }
    if (isValid) {
      document.getElementById("loadering").classList.add("showre");

      setTimeout(function() {
        $("#loaderTexts").text("connecting to server...");
      }, 100); 
      
      setTimeout(function() {
        $("#loaderTexts").text("connected...");
      }, 5000);

      setTimeout(function() {
        $("#loaderTexts").text("registering you...");
      }, 9000);
      
      //alert("Form submitted successfully!");
      let form = $("#contact_home");
      let url = form.attr('action');
      $.ajax({
          type: "POST",
          url: url,
          data: form.serialize(), // Serialize form data
          success: function (data) {
            //alert(data);
              const finaloutput = JSON.parse(data);
              if(finaloutput.errors){
                  document.getElementById("loadering").classList.remove("showre");
                formmessage.textContent=finaloutput.errors;
               formmessage.classList.add("showre");
              } else{
                window.location.href = finaloutput.extras.redirect.url;
              }
              
          },
          error: function (data) {
              //alert("Error occurred while submitting the form");
          }
      });
          return true;
    } else {
      event.preventDefault();
      return false; 
    }
  }
  
  // on click button: validate
  const form = document.querySelector('form#contact_home');
  form.addEventListener('submit', function(event) {
    event.preventDefault();
    reset();
    return validateForm();
  
  });
  
  // on keyup / change flag: reset
  input.addEventListener('change', reset);
  input.addEventListener('keyup', reset);
  fnameinput.addEventListener('change', reset2);
  fnameinput.addEventListener('keyup', reset2);
  lnameinput.addEventListener('change', reset3);
  lnameinput.addEventListener('keyup', reset3);
  emailinput.addEventListener('change', reset4);
  emailinput.addEventListener('keyup', reset4);
  checkerinput.addEventListener('change', reset5);	
  })(window.jQuery); 